/*	blockio.c	1.4	83/05/13	*/

#include <stdio.h>
#include "hdos.h"

#define HDOS_GROUP_SECTOR(c,gno)	(((gno)*HDOS_GROUPSIZE(c))%HDOS_SECTORS(c))
#define HDOS_GROUP_TRACK(c,gno)	(((gno)*HDOS_GROUPSIZE(c))/HDOS_SECTORS(c))

/*
 * Get a complete group into the buffer.  Buffer must be big enough!
 */

int
hdos_getgroup(struct hdosfs *hdosfs, int groupno, char buffer[])
{
    int sect, track, counter;

    /* Translate group number into logical track/sector address */

    sect = HDOS_GROUP_SECTOR(hdosfs,groupno);
    track = HDOS_GROUP_TRACK(hdosfs,groupno);

    /* read the group */
    for (counter = 0; counter < HDOS_GROUPSIZE(hdosfs); counter++) {
	if (!hdos_getpsect(hdosfs, track, sect, buffer+(HDOS_SECTSIZE(hdosfs)*counter))) {
	    return(FALSE);
	}
	sect++;
	if (sect == HDOS_SECTORS(hdosfs)) {
	    sect = 1;
	    track++;
	}
    }

    return (TRUE);
}

/*
 * Save a group out to the floppy.
 */

int
hdos_putgroup(struct hdosfs *hdosfs, int groupno, char buffer[], int sectors)
{

    int sect, track, counter;

    /* Translate group number into logical track/sector address */

    sect = HDOS_GROUP_SECTOR(hdosfs,groupno);
    track = HDOS_GROUP_TRACK(hdosfs,groupno);

    /* write the group */
    /* note that the "sectors" are the number of sectors to write in the group	*/

    for (counter = 0; sectors-- && counter < HDOS_GROUPSIZE(hdosfs); counter++) {
	if (!hdos_putpsect(hdosfs, track, sect,buffer+(HDOS_SECTSIZE(hdosfs)*counter))) {
	    return(FALSE);
	}
	sect++;
	if (sect == HDOS_SECTORS(hdosfs)) {
	    sect = 0;
	    track++;
	}
    }
    return (TRUE);
}
